<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    * Classe che con i metodi delle API di sistema di Geecom, che offrono metodi per svolgere operazioni comuni
    * nella piattaforma
    */
     
    class ApiSistema {
        private $db;
        private $datiGeecomCms;
        
        /* creo il costruttore, ovvero il metodo che crea il nostro oggetto */
        public function __construct($db) {
            $this->db = $db;
            $this->datiGeecomCms = $this->db->leggiSingolaRiga("geec_prodotti",1);
        }

        /*
         * metodo per la creazione della categoria
         */
        function aggiornaCampoTabella() {
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $tabella = filter_input(INPUT_GET,"tabella",FILTER_SANITIZE_ADD_SLASHES);
            $id      = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
            $campo   = filter_input(INPUT_GET,"campo",FILTER_SANITIZE_ADD_SLASHES);
            $valore  = filter_input(INPUT_GET,"valore",FILTER_SANITIZE_ADD_SLASHES);
            
            if($tabella!="geec_utenti") { // la tabella utenti non può essere aggiornata in questo modo per evitare problemi di sicurezza
                $query = "UPDATE $tabella SET $campo='$valore' WHERE id=$id";
                $this->db->eseguiQueryScrittura($query);
                echo "ok";
            }
            else {
                echo "Operazione non permessa!";
            }
        }
        
        function aggiungiComponenteContenuto($idContenuto,$idComponente,$tipoElemento) {
            
            //recupero l'ultima posizione occupata nel pannello laterale
            // le occorrenze di geecB_composizionePagine prese in considerazione sono solo quelle di tipo contenuto (devono essere escluse quelle delle sezioni multiple)
            $queryUltimaPosizione = "SELECT posizione FROM geecB_composizionePagine WHERE idPagina=$idContenuto AND tipoElemento LIKE '$tipoElemento' ORDER BY posizione DESC LIMIT 1";
            $risPosizione    = $this->db->eseguiQueryLettura($queryUltimaPosizione);
            if($risPosizione->num_rows>0) {
                $ultimaPosizione = $risPosizione->fetch_assoc();
                $posizione = $ultimaPosizione["posizione"]+1;
            }
            else {
                $posizione = 1;
            }
            
            $idElemento = $this->creaComponente($idComponente, $idContenuto,$tipoElemento);
            
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $this->db->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecB_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'$idComponente',$idContenuto,'$tipoElemento',$idElemento,$posizione,'$idSezione')";
            $this->db->eseguiQueryScrittura($queryAggiornamentoProdotto);
        }
        
        function aggiungiComponenteSezioneContenuto($idContenuto,$idComponente,$tabellaSezione,$idSezioneNuovoElemento,$posizioneNuovoElementoSezione) {
            $idElemento = $this->creaComponente($idComponente, $idContenuto, "contenutoSezione");
            
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $this->db->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecB_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'$idComponente',$idContenuto,'contenutoSezione',$idElemento,0,'$idSezione')";
            $idComponenteSezione = $this->db->eseguiQueryCreazione($queryAggiornamentoProdotto);
            
            $queryAggiornamentoSezione = "UPDATE $tabellaSezione SET idComponenteSezione$posizioneNuovoElementoSezione = $idComponenteSezione WHERE id=$idSezioneNuovoElemento";
            $this->db->eseguiQueryCreazione($queryAggiornamentoSezione);
        }
        
        public function creaComponente($idComponente, $idContenuto,$tipoElemento) {
            $datiComponente = $this->db->leggiSingolaRiga("geecB_componenti",$idComponente);
            $stringaTipoElemento = ($tipoElemento=="categoriaSopraArticoli" || $tipoElemento=="categoriaSottoArticoli") ? "categoria" : $tipoElemento;
            
            if(($datiComponente["tipo"]=="componenteDinamicoPagine" || $datiComponente["tipo"]=="componenteStrutturaPagina") && $datiComponente["tabellaRiferimento"]!="") {
                $datiPagina       = $this->db->leggiSingolaRiga("geecB_contenuti",$idContenuto);
                $nomeComponente   = $this->db->escapeString($datiComponente["nome"]);
                $titoloEscape     = str_replace(array("'","\""),"",$datiPagina["titolo"]);
                $queryInserimento = "INSERT INTO {$datiComponente["tabellaRiferimento"]} (`id`,`nome`) VALUES(NULL,'$nomeComponente $stringaTipoElemento $titoloEscape')";
                return $this->db->eseguiQueryCreazione($queryInserimento);            
            }
            else if($datiComponente["nome"]=="Immagine") {
                $immagine = new Immagine($this->db, 0, $idContenuto, "immagineContenuto");
                return $immagine->crea();
            }
            else if($datiComponente["nome"]=="Singola risorsa") {
                $datiContenuto  = $this->db->leggiSingolaRiga("geecB_contenuti",$idContenuto);
                $nomeComponente = "File ".$datiContenuto["titolo"];
                $fileScaricabile = new FileScaricabile($this->db, 0, $nomeComponente);

                return $fileScaricabile->crea();
            }
            else {
                return 0;
            }
        }
        
        function eliminaComponenteContenuto($idComponente) {
            $this->db->eseguiQueryCancellazione("geecB_composizionePagine", $idComponente);
        }
        
        /*
         * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
         * bisogna considerare le tabelle del contenuto duplicato e non di quell obase
         */
        function modificaPosizioneComponenteContenuto($idContenuto,$idComponente,$tipoElemento,$posizione,$idContenutoDuplicato = 0) {
            
            $idContenutoDaCercare = ($idContenutoDuplicato!=0) ? $idContenutoDuplicato : $idContenuto;
            
            // le occorrenze di geecB_composizionePagine prese in considerazione sono solo quelle di tipo contenuto (devono essere escluse quelle delle sezioni multiple)
            $queryPosizione = "SELECT * FROM geecB_composizionePagine WHERE idPagina=$idContenutoDaCercare AND tipoElemento LIKE '$tipoElemento' AND id != $idComponente ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geecB_composizionePagine SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geecB_composizionePagine SET posizione=$posizione WHERE id = $idComponente ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function stampaCodiceModalModificaComponenteContenuto($percorsoBase,$idComponente) {
            $queryComponente = "SELECT c.id, c.idComponente, cm.nome, cm.tipo, c.posizione, c.testo, c.idSezione, c.classeSezione, c.idElemento, c.animazione, c.altreOpzioni FROM geecB_composizionePagine AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id 
                                    WHERE c.id=$idComponente";
            $risComponente   = $this->db->eseguiQueryLettura($queryComponente);
            $componente      = $risComponente->fetch_assoc();
            
            // recupero le variabili di configurazione presenti in stile.php
            $arrayDimensioniColonna = $GLOBALS["arrayDimensioniColonna"];
            $arrayColori            = $GLOBALS["arrayColori"];
            $arrayAnimazioni        = $GLOBALS["arrayAnimazioni"];
            
            // array aggiuntivi definiti qui (servono solo per il componente intestazione)
            $arrayOpzioniSeparatore = array("Nessuno","Sopra","Sotto");
            $arrayOpzioniAllineamento = array(""=>"Sinistra","text-center"=>"Centro","text-right"=>"Destra");
            ?>
            <div class="modal-header">
                <h5 class="modal-title">Componente <?= $componente["nome"] ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form name="formAggiornaComponente<?= $componente["id"]; ?>" action="<?= $percorsoBase ?>controller/<?=((isset($prodotto)) ? "ecommerce/controllerProdotti.php" : "controllerContenuti.php") ?>" method="post" enctype="multipart/form-data" >
                    <input type="text" class="d-none" name="id" value="<?= $componente["id"] ?>">
                    <input type="text" class="d-none" name="idComponente" value="<?= $componente["idComponente"] ?>">
                    <input type="text" class="d-none" name="operazione" value="modificaComponente">
                    <?php 
                        if($componente["nome"]=="Html") {
                            echo"<textarea class=\"form-control\" name=\"testo\" rows=\"15\">{$componente["testo"]}</textarea>";
                        }
                        else if($componente["nome"]=="Testo") {
                            // codice valido solo fino a quando il c'è un campo
                            $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                            include"../{$this->datiGeecomCms["percorso"]}/include/campiComponenteDinamico.php";
                    ?>

                    <textarea class="tiny"  name="testo" rows="10"><?= $componente["testo"] ?></textarea>
                    <?php
                        }
                        else if($componente["nome"]=="Intestazione") {
                            $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                            include"../{$this->datiGeecomCms["percorso"]}/include/campiComponenteDinamico.php";
                    ?>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputPassword3">Tipo etichetta</label>
                            <select class="form-control" name="opzioneTagH">
                            <?php 
                                $arrayIntestazioneScelta = explode("=",$arrayOpzioni[1]);
                                $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);
                                $arrayOpzioniH = array("h1","h2","h3","h4","h5","h6");
                                foreach($arrayOpzioniH as $elemento) {
                                    if($intestazioneScelta==$elemento) {
                                        echo"<option value=\"$elemento\" selected>$elemento</option>";
                                    }
                                    else {
                                        echo"<option value=\"$elemento\">$elemento</option>";
                                    }
                                }
                            ?>
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputPassword3" >Allineamento</label>
                            <select class="form-control" name="opzioneAllineamento">
                            <?php 
                                // codice valido solo fino a quando il c'è un campo
                                $arrayOpzioneAllineamento = explode("=",$arrayOpzioni[3]);
                                $opzioneAllineamento = str_replace(";","",$arrayOpzioneAllineamento[1]);
                                foreach($arrayOpzioniAllineamento as $classe=>$descrizione) {
                                    if($opzioneAllineamento==$classe) {
                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                    }
                                    else {
                                        echo"<option value=\"$classe\">$descrizione</option>";
                                    }
                                }
                            ?>
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputPassword3" >Separatore</label>
                            <select class="form-control" name="opzioneSeparatore">
                            <?php 
                                // codice valido solo fino a quando il c'è un campo
                                $arrayOpzioneSceltaSeparatore = explode("=",$arrayOpzioni[2]);
                                $opzioneSeparatore = str_replace(";","",$arrayOpzioneSceltaSeparatore[1]);
                                foreach($arrayOpzioniSeparatore as $opzione) {
                                    if($opzioneSeparatore==$opzione) {
                                        echo"<option value=\"$opzione\" selected>$opzione</option>";
                                    }
                                    else {
                                        echo"<option value=\"$opzione\">$opzione</option>";
                                    }
                                }
                            ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputPassword3" >Titolo</label>
                        <input type="text" class="form-control" name="testo" value="<?= $componente["testo"] ?>">
                    </div>
                    <?php
                        }
                        else if($componente["nome"]=="Profili social") {
                            // codice valido solo fino a quando il c'è un campo
                            $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                            include"../{$this->datiGeecomCms["percorso"]}/include/campiComponenteDinamico.php";
                    ?>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputPassword3">Dimensioni icona</label>
                            <select class="form-control" name="opzioneDimensioniIcona">
                            <?php 
                                $arrayIntestazioneScelta = explode("=",$arrayOpzioni[1]);
                                $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);
                                $arrayOpzioniDimensione = array("fa-2x"=>"2x","fa-3x"=>"3x","fa-5x"=>"5x","fa-7x"=>"7x","fa-10x"=>"10x");
                                foreach($arrayOpzioniDimensione as $classe=>$opzione) {
                                    if($intestazioneScelta==$classe) {
                                        echo"<option value=\"$classe\" selected>$opzione</option>";
                                    }
                                    else {
                                        echo"<option value=\"$classe\">$opzione</option>";
                                    }
                                }
                            ?>
                            </select>
                        </div>
                    </div>
                    <?php
                        }
                        else if($componente["nome"]=="Separatore") {
                            // codice valido solo fino a quando il c'è un campo
                            $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                    ?>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputPassword3" >Spazio occupato</label>
                            <select class="form-control" name="opzioneClasseColonne">
                            <?php 
                                $arrayOpzioneSpazioOccupato = explode("=",$arrayOpzioni[0]);
                                $spazioOccupato = str_replace(";","",$arrayOpzioneSpazioOccupato[1]);
                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                    if($spazioOccupato==$classe) {
                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                    }
                                    else {
                                        echo"<option value=\"$classe\">$descrizione</option>";
                                    }
                                }
                            ?>
                            </select>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="inputPassword3">Stile</label>
                            <select class="form-control" name="opzioneStile">
                            <?php 
                                $arrayIntestazioneScelta = explode("=",$arrayOpzioni[1]);
                                $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);
                                $arrayStiliSeparatore = array("stile-1","stile-2","zigzag");
                                foreach($arrayStiliSeparatore as $stile) {
                                    if($intestazioneScelta==$stile) {
                                        echo"<option value=\"$stile\" selected>$stile</option>";
                                    }
                                    else {
                                        echo"<option value=\"$stile\">$stile</option>";
                                    }
                                }
                            ?>
                            </select>
                        </div>
                    </div>
                    <?php
                        }
                        else if($componente["nome"]=="Includi codice") {
                    ?>
                            <div class="form-group">
                                <label for="inputPassword3" >File php da includere</label>
                                <input type="text" class="form-control" name="testo" value="<?= $componente["testo"] ?>">
                                <small>Il file deve essere caricato in <strong>template/include/fileInclusione</strong></small>
                            </div>
                    <?php
                        }
                        else if($componente["nome"]=="Immagine") {
                            $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                            include"../{$this->datiGeecomCms["percorso"]}/include/campiComponenteDinamico.php";

                            if(isset($arrayOpzioni[1]) && $arrayOpzioni[1]!="") {
                                $arrayOpzioneTagAlt = explode("=",$arrayOpzioni[1]);
                                $tagAlt = str_replace(";","",$arrayOpzioneTagAlt[1]);
                            }
                            else {
                                $tagAlt = "";
                            }
                    ?>        
                            <input type="text" class="d-none" name="idElemento" value="<?= $componente["idElemento"]; ?>">

                            <div class="row">    
                                <div class="form-group col-md-6">
                                    <label for="inputPassword3" >Testo alternativo</label>
                                    <input type="text" class="form-control" name="tagAlt" value="<?= $tagAlt ?>">
                                    <small>Inserire il tag alt migliora l'indicizzazione della pagina</small>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="inputPassword3">Carica file</label>
                                    <input type="file" class="form-control-file" id="inputFile" name="file" accept="image/*">
                                </div>
                            </div>

                            <img class="img-fluid w-100 border" src="<?= (($componente["testo"]) ? "$percorsoBase{$componente["testo"]}" : $percorsoBase."immagini/altro/segnaposto.png"); ?>" >
                    <?php
                        }
                        else if($componente["nome"]=="Audio") {
                            $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                            include"../{$this->datiGeecomCms["percorso"]}/include/campiComponenteDinamico.php";
                    ?>        
                            <input type="text" class="d-none" name="idElemento" value="<?= $componente["idElemento"]; ?>">
                            <div class="form-group">
                                <label for="inputPassword3">Carica file</label>
                                <input type="file" class="form-control-file" id="inputFile" name="file" accept="audio/*" multiple="">
                                <small>Il file caricato attualmente è <?= $componente["testo"]; ?></small>
                            </div>

                    <?php
                        }
                        else if($componente["nome"]=="Singola risorsa") {
                            $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                            include"../{$this->datiGeecomCms["percorso"]}/include/campiComponenteDinamico.php";

                            if(isset($arrayOpzioni[1])) {
                                $arrayOpzioneNomeRisorsa = explode("=",$arrayOpzioni[1]);
                                $nomeRisorsa = str_replace(";","",$arrayOpzioneNomeRisorsa[1]);
                            }
                            else {
                                $nomeRisorsa = "";
                            }
                    ?>        
                            <input type="text" class="d-none" name="idElemento" value="<?= $componente["idElemento"]; ?>">

                            <div class="form-group">
                                <label for="inputPassword3" >Nome risorsa</label>
                                <input type="text" class="form-control" name="nomeRisorsa" value="<?= $nomeRisorsa; ?>">
                                <small>Nome della risorsa</small>
                            </div>

                            <div class="form-group">
                                <label for="inputPassword3">Carica file</label>
                                <input type="file" class="form-control-file" id="inputFile" name="file" multiple="">
                                <small>Il file caricato attualmente è <?= $componente["testo"]; ?></small>
                            </div>
                    <?php
                        }
                    ?>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                <button type="button" class="btn btn-primary btn-sm" onclick="document.formAggiornaComponente<?= $componente["id"]; ?>.submit()"><i class="fas fa-check"></i> Salva</button>
            </div>
            <?php
        }
        
        function cambiaIdElementoComponenteContenuto($idComponente,$idElemento) {
            $query = "UPDATE geecB_composizionePagine SET idElemento=$idElemento WHERE id=$idComponente";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function invertiValoreNascostoComponente($idComponente) {
            $componenteDaModificare = $this->db->leggiSingolaRiga("geecB_composizionePagine",$idComponente);
            
            if($componenteDaModificare["nascosto"]=="si") {
                $valoreAggiornato = "no";
            }
            else {
                $valoreAggiornato = "si";
            }
            
            $queryModifica   = "UPDATE geecB_composizionePagine SET nascosto='$valoreAggiornato' WHERE id=$idComponente";                
            $this->db->eseguiQueryLettura($queryModifica);
            return $valoreAggiornato;
        }
        
        /*
         * qui va aggiunto un parametro alias che deve essere passato dall'utente
         */
        function incrementaClickSlide($id) {
            $slide = $this->db->leggiSingolaRiga("geec_slide",$id);
            $conteggioAggiornato  = $slide["numeroClick"] +1;
            $dataClick = date("Y-m-d H:i");
            $query = "UPDATE geec_slide SET numeroClick = '$conteggioAggiornato', dataUltimoClick='$dataClick' WHERE id=$id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        // GETTER E SETTER
        function getDb() {
            return $this->db;
        }

        public function setDb($db): void {
            $this->db = $db;
        }
    }